require( "scripts/tutorialdefines.lua" );

--[[ Default tutorial action format is as follows:
	{
		action = eTutorial_Wait, 
		actionID = -1, 
		mX = -1, 
		mY = -1, 
		arrow1X = -1, 
		arrow1Y = -1, 
		arrow1Rot = -1, 
		arrow2X = -1, 
		arrow2Y = -1, 
		arrow2Rot = -1, 
		arrow3X = -1,
		arrow3Y = -1,
		arrow3Rot = -1, 
		textName = "", 
		finished = false, 
		gameMode = 0
	},
]]--


kTopRightBoxX = 625;
kTopRightBoxY = 120;

kTopLeftBoxX = 160;
kTopLeftBoxY = 120;

kLineX = 85;
kLineY = 350;

kLine2X = 85;
kLine2Y = 300;

kTable1X = 480;
kTable1Y = 350;

kTable2X = 320;
kTable2Y = 215;

kTicketX = 305;
kTicketY = 65;

kFoodX = 350;
kFoodY = 75;

kDishCartX = 585;
kDishCartY = 180;

kUpgradeButtonX = 400;
kUpgradeButtonY = 490;

kEndlessLivesX = 600;
kEndlessLivesY = 490;


tutorial = 
{
	{
		action = eTutorial_Wait, 
	},
	
	{
		action = eTutorial_PickupCustomers, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kLineX, 
		arrow1Y = kLineY, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable1X, 
		arrow2Y = kTable1Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_0", 
	},
	
	{
		action = eTutorial_DropCustomers, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_1", 
	},
	
	{
		action = eTutorial_WaitForOrder, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_2", 
	},
	
	{
		action = eTutorial_TakeOrder, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown,  
		textName = "tutorial_3", 
	},
	
	{
		action = eTutorial_DropTicket, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTicketX, 
		arrow1Y = kTicketY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_4", 
	},
	
	{
		action = eTutorial_WaitForChef, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		textName = "tutorial_5", 
	},
	
	{
		action = eTutorial_PickupFood, 
		actionID = 1, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kFoodX, 
		arrow1Y = kFoodY, 
		arrow1Rot = kArrowDown,
		textName = "tutorial_6", 
	},
	
	{
		action = eTutorial_DropFood, 
		actionID = 1, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_7", 
	},
	
	{
		action = eTutorial_WaitForEat, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_8", 
	},
	
	{
		action = eTutorial_DropCheck, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_9", 
	},
	
	{
		action = eTutorial_UpgradeButton, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kUpgradeButtonX, 
		arrow1Y = kUpgradeButtonY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_upgradebutton", 
		gameMode = 2
	},
	
	{
		action = eTutorial_WaitTime, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_10", 
		gameMode = 1
	},
	
	{
		action = eTutorial_WaitTime, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_10a", 
		gameMode = 2
	},
	
	{
		action = eTutorial_WaitForLeave, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_10", 
	},
	
	{
		action = eTutorial_PickupPlates, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_11", 
	},
	
	{
		action = eTutorial_DropPlates, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kDishCartX, 
		arrow1Y = kDishCartY, 
		arrow1Rot = kArrowRight, 
		textName = "tutorial_12", 
	},
	
	{
		action = eTutorial_Wait, 
	},
	
	{
		action = eTutorial_PickupCustomers, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = 65, 
		arrow1Y = 300, 
		arrow1Rot = 0, 
		textName = "tutorial_14", 
	},
	
	{
		action = eTutorial_DropCustomers, 
		actionID = 1,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown,
		textName = "tutorial_13", 
	},
	
	{
		action = eTutorial_PickupCustomers, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kLine2X, 
		arrow1Y = kLine2Y, 
		arrow1Rot = 0, 
		textName = "tutorial_14_a", 
	},
	
	{
		action = eTutorial_DropCustomers, 
		actionID = 2,
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY,
		arrow1X = kTable2X, 
		arrow1Y = kTable2Y,  
		arrow1Rot = kArrowDown,
		textName = "tutorial_1", 
	},
	
	{
		action = eTutorial_WaitForOrder, 
		actionID = 1, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_2", 
	},
	
	{
		action = eTutorial_WaitForOrder, 
		actionID = 2, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_2", 
	},
	
	{
		action = eTutorial_TakeOrder, 
		actionID = 1, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTicketX, 
		arrow2Y = kTicketY, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_15", 
	},
	
	{
		action = eTutorial_TakeOrder, 
		actionID = 2, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTable2X, 
		arrow1Y = kTable2Y, 
		arrow1Rot = kArrowDown,  
		arrow2X = kTicketX, 
		arrow2Y = kTicketY, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_16", 
	},
	
	{
		action = eTutorial_DropTicket, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTicketX, 
		arrow1Y = kTicketY, 
		arrow1Rot = kArrowDown, 		
		textName = "tutorial_16", 
	},
	
	{
		action = eTutorial_DropTicket, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTicketX, 
		arrow1Y = kTicketY, 
		arrow1Rot = kArrowDown, 		
		textName = "tutorial_16", 
	},
	{
		action = eTutorial_WaitForChef, 
		actionID = 1, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		textName = "tutorial_17", 
	},
	{
		action = eTutorial_WaitForChef, 
		actionID = 2, 
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		textName = "tutorial_17", 
	},
	
	{
		action = eTutorial_PickupFood, 
		actionID = 1,
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kFoodX, 
		arrow1Y = kFoodY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_18", 
	},
	
	{
		action = eTutorial_PickupFood, 
		actionID = 2,
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kFoodX, 
		arrow1Y = kFoodY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_18", 
	},
	
	{
		action = eTutorial_DropFood, 
		actionID = -1,
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_19", 
	},
	
	{
		action = eTutorial_DropFood, 
		actionID = -1,
		mX = kTopRightBoxX, 
		mY = kTopRightBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_19", 
	},
	
	{
		action = eTutorial_WaitForEat, 
		actionID = 1,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_20", 
	},
	
	{
		action = eTutorial_WaitForEat, 
		actionID = 2,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY,  
		textName = "tutorial_20", 
	},
	
	{
		action = eTutorial_DropCheck, 
		actionID = -1,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_21", 
	},
	
	{
		action = eTutorial_DropCheck, 
		actionID = -1,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_21", 
	},
	
	{
		action = eTutorial_PickupPlates, 
		actionID = -1,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_PickupPlates, 
		actionID = -1,
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_DropPlates, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_DropPlates, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_WaitTime, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_23", 
		gameMode = 1
	},
	
	{
		action = eTutorial_WaitTimeLonger, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		arrow1X = kEndlessLivesX, 
		arrow1Y = kEndlessLivesY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_endless_lives", 
		gameMode = 2
	},
	
	{
		action = eTutorial_WaitTimeLonger, 
		mX = kTopLeftBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_endless_end", 
		gameMode = 2
	},
};